#if !defined(AFX_IDDA_MAIN_H__AD4CB8A2_D0DA_11D2_BDFF_B4F11F5CEB0D__INCLUDED_)
#define AFX_IDDA_MAIN_H__AD4CB8A2_D0DA_11D2_BDFF_B4F11F5CEB0D__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

const char version[]	= "v1.0db105";
const char date[]		= "1999-04-29";
const char helpstr1[] = "idDA - id Demo Analyzer (Q1/Q2/QW)";
const char helpstr2[] = "Programmed by Fabian Huester, spike@planetquake.com";

#include <string.h>
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <direct.h>
#include <time.h>
#include <fcntl.h>
#include <process.h>
#include "analyzedemo.h"
#include "parsedemo_q2.h"
#include "parsedemo_qw.h"
#include "parsedemo_log.h"
#include "configdata.h"
#include "demodata.h"
#include "resultdata.h"
#include "write_log.h"
#include "write_graph.h"
#include "error.h"
#include "output.h"

class idda_main  
{
public: // Variables
private:
	char* current_name;
	configdata* config;
	demodata* data;
	resultdata* result;
public: // Functions
	void run (int argc, char** argv);
	idda_main();
	virtual ~idda_main();
private:
	int mapcount;
	char* maplist [1024];
	int make_maplist (char** maplist, demodata* data);
	void open_graphs();
	void open_logs();
	void open_results();
	void get_prefix (char* str);
	void analyze (char* pathstr);
	void get_configpath (char* configpath, char* execstr);
	void output_time (double time);
	void write_results();
	void write_logs ();
	void write_graphs ();
	void help ();
};

#endif // !defined(AFX_IDDA_MAIN_H__AD4CB8A2_D0DA_11D2_BDFF_B4F11F5CEB0D__INCLUDED_)
